#include "GetPoint.js"
#include "GetCircle.js"

function GetCylinder( factory )
{
	var ui = moi.ui;

	var pointpicker = ui.createPointPicker();

	if ( !GetPoint( pointpicker ) )
		return false;
		
	var PickedBasePt = pointpicker.pt;
	
	if ( !GetCircleRadius( pointpicker, factory, false ) )
		return false;

	ui.beginUIUpdate();
	ui.hideUI( 'RadiusPrompt' );
	ui.hideUI( 'RadiusOptions' );
	ui.showUI( 'EndPrompt' );
	ui.showUI( 'HeightOptions' );
	ui.endUIUpdate();

	ui.removeLastPickedPoint();

	var pointpicker = ui.createPointPicker();
	pointpicker.bindResultPt( factory.getInput( 4 ) );

	var BasePt = factory.getInput(1).getValue().origin;

	ui.commandUI.g_BasePt = BasePt;
	pointpicker.bindFunc( ui.commandUI.OnEndPoint );
	pointpicker.setBasePt( PickedBasePt );

	while ( 1 ) 
	{
		if ( !pointpicker.waitForEvent() )
			return false;

		if ( pointpicker.event == 'finished' )
		{
			break;
		}
		else if ( pointpicker.event == 'height' )
		{
			factory.setInput( 5, ui.commandUI.height.value );
			factory.update();
			ui.commandUI.g_HaveHeight = true;
		}
	}
	
	return true;
}
